#ifndef __C_LAYERINFO_H
#define __C_LAYERINFO_H

#include "Interfaces/cObject.h"

class cLayer;

/*
 * cLayerInfo.h
 *
 * Information returned by a layer upon registration
 */
class cLayerInfo : public cObject
{
  public:
	  cLayerInfo()	{ mMTS = 0; mCumHeaderSize = 0; mLayerBelow = NULL; }

	  void operator=(const cLayerInfo& x)
	  {
		mMTS = x.mMTS;
		mCumHeaderSize = x.mCumHeaderSize;
		mLayerBelow = x.mLayerBelow;
	  }

	  unsigned int GetMTS()			{ return mMTS; }
	  unsigned int GetCumHeaderSize()  { return mCumHeaderSize; }

	  void	SetMTS(unsigned int mts) {  mMTS = ((mMTS == 0) || (mMTS > mts)) ? mts : mMTS; }
	  void	AddHeaderSize(unsigned int size) { mCumHeaderSize += size; }

	  cLayer*	 GetLayerBelow()	{ return mLayerBelow; }
	  void		 SetLayerBelow(cLayer* layer) { mLayerBelow = layer; }

  private:
	unsigned int mMTS;				// Maximum transfer size (for data payload...includes mHeaderSize)
	unsigned int mCumHeaderSize;	// Maximum size of headers for this and below layer(s).
	cLayer*		 mLayerBelow;		// The layer below the current one.
};

#endif
